//	Persistence of Vision Ray Tracer Scene Description File
//render at 640x480 for 3.67x7.25 @ 100%
//2672x2004 for 300 dpi? trims to 2178x1103
//use MegaPOV 1.0
//PNG 8 bit
//anti-aliasing 2 adaptive
//threshold 0.5, recursion 3, jitter 0.5
//in line with text

#include "colors.inc"
#include "sheet.inc"
#include "dice.inc"
#include "pencil.inc"
#declare DEM_Scale = 1;
#include "landscape.inc"
#declare notexture = 1;
#include "pandora.inc"
#declare writingFont = "JeninesHand.ttf"

camera {
	perspective 
	location <0,5,-4>
	look_at <0,0,0>
}
light_source {
	<60, 100, -100>
	White
}

background {
	rgb <1, 1, 1>
}


//graph paper sheet
union {
	object { makeGraph(graphTypeHex)
		rotate <90,90,0>
	}
	object {
		makeUnitTextBox("Haunted Island",TCENTER,writingFont,penThickness)
		rotate <90,0,0>
		scale <3.5,3,3.5>
		translate <0,0,-2.09>
	}
	object {
		makeUnitTextBox("1 sq = .5 mi", TCENTER, writingFont, penThickness)
		rotate <90,0,0>
		scale <.8,3,1>
		rotate <0,-10,0>
		translate <-2,0,-1.09>
	}
	union {
		object {
			makeUnitTextBox("2 goblins, 6sp & 5 sp",TLEFT,writingFont,penThickness)
			rotate <90,0,0>
			scale <1.1,1,1.1>
		}
		object {
			makeUnitTextBox("1 large spider, 11 sp", TLEFT, writingFont,penThickness)
			rotate <90,0,0>
			translate <0,0,-.15>
			scale <1.25,1,1.25>
		}
		rotate <0,10,0>
		scale <1,2.5,1>
		translate <1,0,-1.2>
	}
}

//2d6
union {
	object {
		facedie6(2)
		material { diered }
		translate <-3.5,0,-1>
	}
	object {
		facedie6(4)
		material { diered }
		translate <.5, 0, .5>
	}
	translate <0,1,0>
	scale .19
	translate <-2,0,1>
}

//twenty-sider
object { die20
	rotate <-90,0,0>
	translate <0,1,0>
	scale .19
	material { diegreen }
	rotate <0,150,0>
	translate <2,0,-1>
}

//eight-sider
object {
	facedie8(5)
	scale .17
	material { dieorange }
	rotate <0,45,0>
	translate <-2.5, 0, 0>
}

//d100
union {
	object {
		facedie10(0)
		material { dieblue }
		rotate <0, -10, 0>
		translate <-.6,0,-.1>
	}
	object {
		facedie10(8)
		material { dieorange }
		rotate <0,15,0>
		translate <.7,0,0>
	}
	scale .45
	rotate <0, 25, 0>
	translate <1.75,0,-1.75>
}

object { aPencil
	rotate <0,40,0>
	translate <.75,0,-1.5>
}
#declare white = color rgb <1, 1, 1>;
#declare lego_finish = finish { ambient 0.4 specular 1 roughness 0.005 reflection .1 }
#declare white_tex = texture { pigment { color white } finish { lego_finish } }

object { temple
	rotate <0,30,0>
	scale .005
	translate <-2,0,-1.5>
	texture {
		white_tex
	}
}


//landscape
height_field {
	tga "HAIKU, HI-24000_pov.tga"
	texture { landscape_T
		translate <0, -.001, 0>
	}
	translate <-0.5, -.001, -0.5>
	rotate <0,180,0>
	scale <1.000000, 1.508691, 1.061934> // restore DEM aspect ratios (e,u,n)
	scale 2.5
	//scale 43438.320312 // scale DEM to true size (feet)
	//scale 0.3048 // scale to meters (remove this line to get feet)
	scale <1.3, 1.5, 1.0> // vertical exaggeration (middle number)
}

plane {
	y,0
	
	pigment {
		color White
	}
	finish {
		ambient paperAmbient
		diffuse 1000
	}
	translate <0,-.01,0>
}