//pencil
#declare pencilRadius = .1;
#declare leadRadius = pencilRadius*.2;
#declare pencilLength = 4.5;
#declare pointLength = pencilLength/15;
#declare theAngle = radians(90-180/8);
#declare halfSide = pencilRadius/tan(theAngle);
#declare wideRadius = pencilRadius/sin(theAngle);
#declare thePencilWood = prism {
	linear_spline
	linear_sweep
	0,pencilLength
	9
	<halfSide,-pencilRadius>,
	<pencilRadius,-halfSide>,
	<pencilRadius,halfSide>,
	<halfSide,pencilRadius>,
	<-halfSide,pencilRadius>,
	<-pencilRadius,halfSide>,
	<-pencilRadius,-halfSide>,
	<-halfSide,-pencilRadius>,
	<halfSide,-pencilRadius>
	pigment {
		color (Yellow+Orange)/2
	}
	normal {
		dents 2
		scale .05
	}
	finish {
		ambient .35
	}
}

#declare aPencil = union {
	//lead
	cylinder {
		<0,0,0>,<0,pencilLength,0>,leadRadius
		texture {
			pigment {
				color White*.15
			}
		}
	}
	intersection {
		object { thePencilWood }
		cone {
			<0,0,0>,0
			<0,pointLength,0>,wideRadius
			pigment {
				color Tan
			}
			finish {
				ambient .35
			}
		}
	}
	object { thePencilWood
		scale <1,(pencilLength-pointLength)/pencilLength,1>
		translate <0,pointLength,0>
	}

	rotate <90,0,0>
	translate <0,pencilRadius,0>
	
}
