
#declare grassy_p = pigment {
	gradient y
	turbulence .5
	color_map {
		[0.0	color Tan*.7]
		[0.2	color Tan*.7]
		[1.0	color Green*.5]
	}
	scale 8
	//color Green*.5
}
#declare grassy_n = normal {
	gradient y
	turbulence .5
	normal_map {
		[0.0	ripples .5 turbulence .25 scale 1]
		[0.2	ripples .5 turbulence .25 scale 1]
		[1.0	wrinkles 2 turbulence .25 scale .2]
	}
}
#declare grassy_f = finish {
	ambient .45
}
#declare bumpy_n = normal {
	wrinkles 1
	turbulence .25
	scale .2
}
#declare bumpy_f = finish {
	ambient .5
}
#declare grass = texture {
	pigment { grassy_p }
	normal { grassy_n }
	finish { grassy_f }
}
#declare grassybump = texture {
	pigment { grassy_p }
	normal { bumpy_n }
	finish { bumpy_f }
}



#include "metals.inc"
#declare farmerwaves = texture {
		T_Chrome_2D
		normal {
			waves 0.05
			frequency 5000.0
			scale 3000.0
		}
}


#declare xwaves = 	texture {
	pigment {
		color White filter .5
	}
	normal {
		gradient x, 3
		sine_wave
		turbulence <.4,.1,0>
		scale <2,1,2>
	}
	finish {
		reflection .7
		specular 0.4
		roughness 0.2
	}
}

#declare zwaves = 	texture {
	pigment {
		color White filter .5
	}
	normal {
		gradient z, 3
		sine_wave
		turbulence <.4, .1, 0>
		scale <2, 1, 2>
	}
	finish {
		reflection .7
		specular 0.4
		roughness 0.2
	}
}


#declare jerrywaves = texture {
	bozo
	texture_map {
		[0.0 xwaves]
		[0.4 zwaves]
		[0.6 zwaves]
		[0.8 xwaves]
		[1.0 xwaves]
	}
}


#declare seabed = texture {
	pigment {
		color Tan*.25
	}
	normal {
		gradient x, 1
		sine_wave
		turbulence <.3,.1,0>
	}
	finish {
		ambient .5
	}
}


//the sky (modified from skies.inc)

#declare P_Cloud2 = pigment {
	wrinkles
	turbulence 0.65
	octaves 6
	omega 0.7
	lambda 2
	color_map {
		[0.0, 0.1	color red 0.85 green 0.85 blue 0.85
					color red 0.75 green 0.75 blue 0.75]
		[0.1, 0.5	color red 0.75 green 0.75 blue 0.75
                    color rgb <0.258, 0.258, 0.435>  ]
		[0.5, 1.001 color rgb <0.258, 0.258, 0.435>
					color rgb <0.258, 0.258, 0.435> ]
	}
	scale <6, 1, 6>
}
#declare P_Cloud3 = pigment {
	bozo
	color_map {
		[0.0, 0.1	color red 0.85 green 0.85 blue 0.85
					color red 0.55 green 0.60 blue 0.65]
		[0.1, 0.5	color red 0.55 green 0.60 blue 0.65
					color rgb <0.184, 0.184, 0.309> ]
		[0.5, 1.001	color rgb <0.184, 0.184, 0.309>
					color rgb <0.1, 0.1, 0.2>]
	}
	turbulence 0.65
	octaves 6
	omega 0.707
	lambda 2
	scale <6, 4, 6>
}




#macro connectTheShore(startPoint, endPoint, genRadius)
	cylinder {
		startPoint, endPoint, genRadius, 1
	}
#end

