//	Persistence of Vision Ray Tracer Scene Description File
//render at 640x480 for 3.67x7.25 @ 100%
//2672x2004 for 300 dpi? trims to 2178x1103
//use MegaPOV 1.2
//PNG 8 bit
//anti-aliasing 2 adaptive
//threshold 0.3, recursion 3, jitter 0.5
//in line with text

#declare highTree = true;
#declare finalRender = true;

#include "colors.inc"
#declare notexture = 1;
#include "includes/pandora.inc"
#include "includes/ground.inc"

#if(highTree | finalRender)
	#include "includes/olive_foliage.inc"
#else
	#declare BlankTree = sphere {
		<0, .3, .15>, .3
	}
#end

#declare sealevel = 0;
#declare landheight = 2;
#declare seafloor = -4;
#declare earth_radius = 50000;

camera {
	perspective 
	location <0,15+sealevel,-50>
	look_at <0,15+sealevel,0>
}
light_source {
	<60, 100+sealevel, -100>
	White
}

background {
	rgb <1, 1, 1>
}

//two columns
#declare sealboxwidth = 8;
#declare sealboxheight = sealboxwidth*1.8;
#declare steppes = union {
	#declare sbwmult = 1.4;
	#declare sbwht = sealboxwidth/8;
	#declare sbcounter = 0;
	
	#while (sbwmult > 1)
		box {
			<-sealboxwidth*sbwmult, -sbwht, -sealboxwidth*sbwmult>,
			<sealboxwidth*sbwmult, sbwht, sealboxwidth*sbwmult>
			translate <0, sealboxheight-sbcounter, 0>
		}
		#declare sbwmult = sbwmult - .1;
		#declare sbcounter = sbcounter + 1;
	#end
}

#declare medallionR = sealboxwidth*2/3;
#declare crossW = medallionR/5;
#declare medallionS = 1.3333;
#declare medallion = cylinder {
	<0, 0, -sealboxwidth*1.01>
	<0, 0, -sealboxwidth*.9>
	medallionR
	scale <1, medallionS, 1>
	texture { PinkAlabaster }
}
#declare cross = union {
	box {
		<-medallionR, -crossW, -sealboxwidth*.99>,
		<medallionR, crossW, -sealboxwidth*.89>
		translate <0, crossW, 0>
	}
	box {
		<-crossW, -medallionR, -sealboxwidth>
		<crossW, medallionR, -sealboxwidth*.89>
		scale <1, medallionS, 1>
	}
	texture { PinkAlabaster }
}

#declare cup = lathe {
	cubic_spline
	14,
	<-60,-68>,
	<0,-68>,
	<60,-68>,
	<63,-66>,
	<30,-56>,
	<12,-33>,
	<9,-7>,
	<6,-4>,
	<6,2>,
	<12,2>,
	<44,20>,
	<57,61>,
	<55,63>,
	<-60,63>
	texture { PinkAlabaster	}
	scale .05
	scale <1, 1, .1>
	translate <0, 0, -sealboxwidth*.95>
}

#declare olivetree = object { BlankTree
	texture { PinkAlabaster }
	translate <.1, -.4, 0>
	scale 8
	translate <0, 0, -sealboxwidth*.97>
}


#declare pillar = union {
	object { columnPart //column()
		scale 1.2
		scale <1, 5, 1>
	}

	//the top step and ring
	#declare topstep = 1;
	#declare topring = 1;
	box {
		<-sealboxwidth*topstep, -sbwht, -sealboxwidth*topstep*1.05>,
		<sealboxwidth*topstep, sbwht, sealboxwidth*topstep*1.05>
		translate <0, sealboxheight+1.5, 0>
	}
	torus {
		sealboxwidth, sbwht
		scale .8
		translate <0, sealboxheight+2.5, 0>
	}
	
	object { steppes }
	
	//the ornamentation
	difference {
		box {
			<-sealboxwidth, -sealboxheight, -sealboxwidth>,
			<sealboxwidth, sealboxheight, sealboxwidth>
		}
		object { medallion }
		object { medallion
			rotate <0, 90, 0>
		}
		object { medallion
			rotate <0, 180, 0>
		}
		object { medallion
			rotate <0, 270, 0>
		}		
	}
	object { cup }
	object { cross
		rotate <0, 90, 0>
	}
	object { olivetree
		rotate <0, 180, 0>
	}
	object { cross
		rotate <0, 270, 0>
	}

	//the stepped bottom is a mirror image of the top one
	object { steppes
		scale <1, -1, 1>
	}
	
	//the base
	box {
		<-sealboxwidth*topstep, -sbwht, -sealboxwidth*topstep*1.05>,
		<sealboxwidth*topstep, sbwht, sealboxwidth*topstep*1.05>
		scale 1.6
		translate <0, -(sealboxheight+1), 0>
	}

	translate <0, sealboxheight+sbwht, 0>

	scale .6

	translate <0, sealevel, 0>	

	texture {
		terrace_texture
		scale .01
	}
}

object { pillar
	translate <-20, landheight, 0>
}

object { pillar
	rotate <0, 180, 0>
	translate <20, landheight, 0>
}

//ocean
sphere {
	<0,-earth_radius,0>,earth_radius
	texture {
		farmerwaves
		//jerrywaves
	}
}

//ship

#include "includes/ships.inc"

union {
	#include "includes/greek.inc"
	rotate <-90, 0, 0>
	rotate <0, 50, 0>
	translate <-1, 1.65, 0>
	scale 1
}

#macro makeWater()
	#local ctr = 0;
	#declare oldPos = seashore(1.0);
	mesh {
		#while (ctr <= 1)
			#declare newPos = seashore(ctr);
				//top
				triangle {
					seacentertop,
					<oldPos.x, oldPos.y+defaultRadius, oldPos.z>,
					<newPos.x, newPos.y+defaultRadius, newPos.z>
				}
	
				//bottom
				triangle {
					seacenterbottom,
					<oldPos.x, oldPos.y-defaultRadius, oldPos.z>,
					<newPos.x, newPos.y-defaultRadius, newPos.z>
				}
				
				//shore side
				triangle {
					<oldPos.x, oldPos.y+defaultRadius, oldPos.z>,
					<oldPos.x, oldPos.y-defaultRadius, oldPos.z>,
					<newPos.x, newPos.y-defaultRadius, newPos.z>
				}
				triangle {
					<oldPos.x, oldPos.y+defaultRadius, oldPos.z>,
					<newPos.x, newPos.y-defaultRadius, newPos.z>,
					<newPos.x, newPos.y+defaultRadius, newPos.z>
				}
				
			#declare oldPos = newPos;
			#declare ctr = ctr + ctrstep;
		#end
	
		inside_vector <0, 0, +1>
	}
#end


//land (straits)
//we'll use a spline to determine the edges of the ocean and the sea
#declare ctrstep = .008;
#declare defaultRadius = landheight-seafloor;

difference {
	sphere {
		<0, 0, 0>, earth_radius+landheight
		translate <0, -earth_radius, 0>
		texture { grass }
	}

	//cut out the sea
	#declare seashore = spline {
		natural_spline
		0.0, <-7, 0, 10>,
		.27, <-10, 0, 15>,
		.34, <-20, 0, 20>,
		.43, <-40, 0, 40>,
		.48, <-100, 0, 200>,
		.50, <-50, 0, 300>,
		.52, <0, 0, 400>,
		.55, <40, 0, 295>,
		.62, <80, 0, 200>,
		.69, <40, 0, 40>,
		.75, <20, 0, 15>,
		.80, <11, 0, 8>,
		.90, <10, 0, -15>,
		.95, <2, 0, -12>,
		1.0, <-5, 0, -8>
	}
	#declare seacentertop = <0, defaultRadius, 40>;
	#declare seacenterbottom = <0, -defaultRadius, 40>;
	
	object {
		makeWater()
		translate <0, landheight, 0>
		texture { seabed }
	}

	//cut out the ocean
	#declare seashore = spline {
		//natural_spline
		0.0, <-10, 0, -390>,
		.27, <-13, 0, -385>,
		.34, <-123, 0, -380>,
		.43, <-143, 0, -360>,
		.45, <-303, 0, -200>,
		.47, <-153, 0, -51>,
		.49, <-150, 0, -25>,
		.51 <-15, 0, -22>,
		.52 <-10, 0, 0>,
		.53, <-3, 0, 20>
		.54, <4, 0, 10>,
		.57, <37, 0, -105>,
		.62, <177, 0, -200>,
		.69, <37, 0, -360>,
		.75, <17, 0, -385>,
		.80, <8, 0, -392>,
		.90, <7, 0, -415>,
		.95, <-1, 0, -412>,
		1.0, <-8, 0, -408>
	}
	#declare seacentertop = <0, defaultRadius, -50>;
	#declare seacenterbottom = <0, -defaultRadius, -50>;
	
	object {
		makeWater()
		translate <0, landheight, 0>
		texture { seabed }
	}

}


sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[0.04 rgb <0.847, 0.749, 0.747> ] // horizon
			[0.25 P_Cloud2 scale 0.25 rotate z*5]
			[0.60 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
		}
	}
	rotate <2, 0, 0>
}


