//1 unit = 1 inch
#include "colors.inc"
#include "textures.inc"

#declare feet = 12;
#declare yards = 36;
#declare inches = 1;
#declare miles = 6133*12;
#declare Quarry = seed(1);
#declare Quarry_Size = 1000;

#ifndef(totalspan)
	#declare totalspan=180;
#end

#ifndef(notexture)
	#declare notexture=1;
#end
//Ground
#declare GrassMap = texture {
	pigment { color Green*.5 }
	normal {
		ripples
	}
	finish {
		ambient .4
	}
}
#declare RockyMap = texture {
	pigment { color Brown*.5 }
	normal {
		ripples
	}
	finish {
		ambient .35
	}
}
#declare GroundTexture = texture {
	gradient y
	turbulence 0.5
	texture_map {
		[0.0	GrassMap]
		[0.3	GrassMap]
		[0.35	RockyMap]
		[1.0	RockyMap]
	}
}
//delphic terrace
// White marble with grey veins. (modified from textures.inc)
#declare crackling = normal {
	crackle
}
#declare rockphong = finish {
	phong .7
	phong_size 20
}

#declare terrace_texture = texture {
	pigment {
		marble
		turbulence 1
		color_map {
			[0.0 rgb <0.9, 0.9, 1.0>]
			[0.8 rgb <0.7, 0.7, 0.85>]
			[1.0 rgb <0.3, 0.3, 0.3>]
		}
		scale 5
	}
	normal { crackling }
	finish { rockphong }
}
#declare white_texture = texture {
	pigment {
		color White
	}
	normal { crackling }
	finish { rockphong }
}

#declare brick_span = 10; //degrees
#declare step_height = 5*inches;
#declare step_width = 5*inches;
#declare base_cyl_width = 20*step_width;
#declare step_Count = 4;
#declare top_floor_level = step_Count*step_height;
#declare top_floor_width = base_cyl_width - step_width*(step_Count-1);

#macro terrace_brick(floor_width,floor_span,floor_thickness)
	difference {
		cylinder {
			<0,0,0>,<0,step_height,0>,floor_width*.99
		}
		cylinder {
			<0,-.1,0>,<0,step_height*1.1,0>,floor_width-floor_thickness
		}
		box {
			<-floor_width*1.1,-.1,0>,
			<floor_width*1.1,step_height*1.1,floor_width*1.1>
		}
		box {
			<-floor_width*1.1,-.1,-floor_width*1.1>,
			<floor_width*1.1,step_height*1.1,0>
			rotate <0,-floor_span*.98,0>
		}
		#if (notexture = 0)
			#local quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
	}
#end
#macro make_terrace(terrace_height,terrace_width,current_brick_width)
	union {
		#declare total_span = 0;
		#declare current_brick_span = brick_span*base_cyl_width/terrace_width;
		#while (total_span < totalspan)
			object { terrace_brick(terrace_width,current_brick_span,current_brick_width)
				rotate <0,-total_span,0>
			}
			#declare total_span = total_span + current_brick_span;
		#end
	}
#end

#declare middle_width = 6*step_width;
#declare terrace = union {
	#declare current_terrace = 0;
	#while (current_terrace < step_Count)
		#declare current_terrace_width = base_cyl_width-step_width*current_terrace;
		#if (current_terrace < step_Count-1)
			#declare current_step_width = step_width*2;
		#else
			#declare current_step_width = step_width;
		#end
		object {
			make_terrace(step_height,current_terrace_width,current_step_width)
			translate <0,step_height*current_terrace,0>
			#if (current_terrace/2 = int(current_terrace/2))
				rotate <0,brick_span/2,0>
			#end
		}
		#declare current_terrace = current_terrace+1;
	#end
	#while (current_terrace_width-step_width > middle_width)
		object {
			#declare current_terrace_width = current_terrace_width - step_width;
			make_terrace(step_height,current_terrace_width,step_width)
			translate <0,step_height*(step_Count-1),0>
		}
	#end
	#if (totalspan = 180)
	difference {
	#end
		cylinder {
			<0,0,0>,
			<0,step_height*step_Count,0>,
			middle_width*.99
	#if (totalspan = 180)
		}
		box {
			<-middle_width*1.1,-.1,0>
			<middle_width*1.1,step_height*step_Count*1.1,middle_width*1.1>
		}
	#end
		#if (notexture = 0)
			texture { white_texture }
		#end
	}
}

#declare column_count = 8;
#declare column_span = totalspan;
#declare column_height = 7*feet;
#declare column_diameter = 1*feet;
#declare column_parts = 5;
#declare column_part_height = column_height/column_parts;
#declare y_up = 1.1;
#declare y_down = -.1;
#declare part_scale = .92;
#declare groove_count = 21;
#declare column_out = top_floor_width-.5*feet-.5*feet;
#declare top_width = pow(part_scale,column_parts-1)*1.1*column_diameter/2;
#macro x_from_y (y_n)
	(part_scale-1)*y_n+1
#end
#declare groove = cylinder {
	<x_from_y(y_down),y_down,0>,<x_from_y(y_up),y_up,0>,.1
	scale <column_diameter/2,column_part_height,column_diameter/2>
}
#declare columnPart = difference {
	cone {
		<0,0,0>,column_diameter/2,
		<0,column_part_height,0>,part_scale*column_diameter/2
	}
	#declare current_groove = 0;
	#while (current_groove < groove_count)
		object { groove
			rotate <0,current_groove*360/groove_count,0>
		}
		#declare current_groove = current_groove + 1;
	#end
}

#declare curvy_block_height = 8*inches;
#declare curvy_block_out = column_out+top_width;
#declare curvy_block = difference {
	cylinder {
		<0,0,0>,<0,curvy_block_height,0>, curvy_block_out
	}
	cylinder {
		<0,-.1,0>,<0,curvy_block_height*1.1,0>,column_out-top_width
	}
	box {
		<-curvy_block_out*1.1,-.1,0>,
		<curvy_block_out*1.1,curvy_block_height*1.1,curvy_block_out*1.1>
	}
	box {
		<-curvy_block_out*1.1,-.1,-curvy_block_out*1.1>,
		<curvy_block_out*1.1,curvy_block_height*1.1,0>
		rotate <0,-column_span*.99/column_count,0>
	}
	translate <column_out,0,0>
}

#declare frieze_block_height = curvy_block_height*5/4;
#declare frieze_block_width = column_span/3*.99/column_count;
#declare frieze_block_depth = top_width*1;
#declare frieze_center_width = frieze_block_width*2;
#declare frieze_block = box {
	<0,0,0>,<frieze_block_depth,frieze_block_height,frieze_block_width>
	translate <0,0,(frieze_block_width-top_width)/2>
}

#declare curvy_ridge_height = curvy_block_height*.2;
#declare curvy_ridge_out = column_out+top_width;
#declare curvy_ridge = difference {
	cylinder {
		<0,0,0>,<0,curvy_ridge_height,0>, curvy_ridge_out
	}
	cylinder {
		<0,-.1,0>,<0,curvy_ridge_height*1.1,0>,column_out-top_width
	}
	box {
		<-curvy_ridge_out*1.1,-.1,0>,
		<curvy_ridge_out*1.1,curvy_ridge_height*1.1,curvy_ridge_out*1.1>
	}
	box {
		<-curvy_ridge_out*1.1,-.1,-curvy_ridge_out*1.1>,
		<curvy_ridge_out*1.1,curvy_ridge_height*1.1,0>
		rotate <0,-column_span*.99/column_count,0>
	}
	rotate <0,-column_span*.99/column_count/2,0>
	translate <column_out,0,0>
}


#declare R1 = seed(0);
#macro column()
union {
	#local current_part = 0;
	#while (current_part < column_parts)
		object { columnPart
			scale <pow(part_scale,current_part),1,pow(part_scale,current_part)>
			#if (notexture = 0)
				#local quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
			#end
			translate <(.5-rand(R1))/100,current_part*column_part_height*1.0001,0>
		}
		#local current_part = current_part + 1;
	#end
	#local current_top = column_part_height*current_part*1.0001;
	cone {
		<0,0,0>,column_diameter/2*pow(part_scale,column_parts-1),
		<0,.09*column_part_height,0>,top_width
		#if (notexture = 0)
			#declare quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
		translate <0,current_top,0>
	}
	#local current_top = current_top + .09*column_part_height;
	box {
		<-top_width,0,-top_width>,<top_width,.12*column_part_height,top_width>
		#if (notexture = 0)
			#declare quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
		translate <0,current_top,0>
	}
	#local current_top = current_top + .12*column_part_height;
	object { curvy_block
		#if (notexture = 0)
			#declare quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
		translate <0,current_top,0>
	}
	#local current_top = current_top + curvy_block_height;
	object { frieze_block
		#if (notexture = 0)
			#declare quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
		translate <0,current_top,0>
	}
	#local current_top = current_top + frieze_block_height;
	object { curvy_ridge
		#if (notexture = 0)
			#declare quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture translate quarry_loc}
		#end
		translate <0,current_top,0>
	}
	#local current_top = current_top + curvy_ridge_height;
}
#end

#declare temple = union {
	object { terrace }
	#declare current_column = 0;
	#while (current_column < column_count)
		object { column()
			translate <-column_out,top_floor_level,0>
			rotate <0,-current_column*column_span/column_count-.5*column_span/column_count,0>
		}
		#declare current_column = current_column+1;
	#end
}

//vase


//Pandora


//Pandora stepping out of the mist on the right

//Epimetheus


//trees




//Jerry Stratton MCMXCVIII
