//See http://www.geocities.com/ccolefax/download/spweb.txt
//for SPWeb.inc

//2666x1500 for 300 dpi and 640x360 pts
//746x420  for 72 dpi, 5.51x9.7 inches wide

//PNG 8 bit
//anti-aliasing 2 (adapative)
//threshold 0.3
//recursion 2
//jitter 0.5
//alpha channel must be off

#include "colors.inc"
#declare bgColor = color White;

#if (image_width/image_height > 15/9)
	#declare widescreen = true;
#else
	#declare widescreen = false;
#end

background {
	color bgColor
}

camera {
	location <0, 0, -30>
	look_at <0, 1, 0>

	right x*image_width/image_height
}

//spider web

object {
	#declare web_type = 2;
	#declare web_seed = 99;
	#declare web_spokes_turb = 0.9;
	#declare web_circles_turb = 0.5;
	#include "SPWeb.inc"

	rotate <0, -60, 0>
	rotate <0, 0, -20>
	translate <-10, 5, 0>
	no_shadow
	
	texture {
		pigment {
			color rgb <1, .95, .95>
		}
		finish {
			ambient .4
			phong .2
			phong_size 10
		}
	}

	#if (widescreen)
		translate <-4, 0, 0>
	#end
}

//spider
#declare FurColor = color rgb <.65, 1, 0>;
#declare fur1 = texture {
	pigment {
		bozo
		color_map {[0,color FurColor*0.9][1,color FurColor*1.1]}
		scale 0.001
	}
	normal {
		average
		normal_map {
			[bumps 0.3*2 warp {turbulence 1} scale 0.2]
			[bumps 0.2*2 warp {turbulence 0.5} scale 0.001]
		}
	}
	finish {
		//ambient 0.3 // MegaPOV
		ambient 0.05 //POVRay Unofficial 2.7
		diffuse 0.6*2
		brilliance 0.6
	}
}
#declare fur2 = texture {
	pigment {
		color -FurColor
	}
	finish {
		ambient 0
		diffuse 0
	}
}

#declare t_spider = texture {
		wrinkles
		scale 0.01
		texture_map {
			[0 fur1 ]
			[1 fur2 ]
		}
}

#include "ragnospider.inc"

#declare spider_climb = <10, 70, 0>;

union {
	object {ragno
		rotate spider_climb
		translate <0, -10, 0>
	}

	//the ground, for shadows from the spider
	disc {
		0, y, 12
		
		pigment {
			color bgColor
		}
		finish {
			ambient 0.4
			diffuse 4
		}
		rotate spider_climb
		translate <0,-.01,0>
		translate <0, -10, 0>
		
		no_reflection
	}

	//widescreen adjustment
	#if (widescreen)
		translate <12, 0, 0>
	#end
}

//moon
#include "moon.inc"

#declare moonRadius = 173800;
#declare earth2moon = 38450000/10;
#declare earth2sun = 0;
#declare earthRadius = 637800;
#declare earthOffset = -earthRadius - 450000;

#declare moon_location = transform {
	translate <0,0,earth2moon>
	rotate <0,49,25>
	translate <0,0,earth2sun-earthOffset>
	rotate <-6,0,0>
	rotate <0, -55, 0>
	#if (widescreen)
		translate <-earth2moon/2.6, 0, 0>
	#end
}

//moonlight
light_source {
	<0,0,0>
	color rgb <.75,.75,1>
	transform { moon_location }

}

object { WaxingMoon
	scale moonRadius
	scale 1.5
	scale <-1, 1,1 >
	transform {moon_location}
	no_shadow
}

