#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "chars.inc"

#declare pip = sphere {
	0,.3
	pigment {
		color White
	}
}
#declare pip_out = 1.25;
#declare pip_lateral = .475;

#declare diefont = "timrom.ttf"
#declare text_depth = .02;
#declare counter = 20;
#declare textnumber = array[counter+1]
#declare textextent = array[counter+1]
#while (counter > 0)
	#declare textnumber[counter] = text {
		ttf diefont
		str(counter,0,0)
		text_depth, 0
	}
	#if (counter = 6 | counter = 9)
		#declare numbermax = max_extent(textnumber[counter]);
		#declare numbermin = min_extent(textnumber[counter]);
		#declare textnumber[counter] = union {
			text {
				ttf diefont
				str(counter,0,0)
				text_depth, 0
			}
			box {
				<numbermin.x,-.23,0>, <numbermax.x,-.17,text_depth>
			}
		}
	#end
	#declare textextent[counter] = max_extent(textnumber[counter]);
	#declare counter = counter - 1;
#end

#declare diered = material {
	texture {
		pigment {
			color Red
		}
		finish {
			ambient .35
		}
	}
}

#declare diegreen = material {
	texture {
		pigment {
			color Green
		}
		finish {
			ambient .3
		}
	}
}
#declare dieorange = material {
	texture {
		pigment {
			color Orange
		}
		finish {
			ambient .3
		}
	}
}
#declare dieyellow = material {
	texture {
		pigment {
			color Yellow
		}
		finish {
			ambient .3
		}
	}
}
#declare dieblue = material {
	texture {
		pigment {
			color rgb <.5,.6,.9>
		}
		finish {
			ambient .3
		}
	}
}
#declare dienumber = material {
	texture {
		pigment {
			color White*.15
		}
		finish {
			ambient .8
		}
	}
}

#declare dienumberwhite = material {
	texture {
		pigment {
			color White*.95
		}
		finish {
			ambient .8
		}
	}
}


// create a superquadric ellipsoid shape
// As the exponents approach 1.0, the edges get rounder
#declare die6 = difference {
	superellipsoid {
		<0.25, 0.25>
	}
	//1 on top
	object { pip translate <0,pip_out,0> }

	//2 on back
	object { pip translate <pip_lateral,pip_lateral,pip_out> }
	object { pip translate <-pip_lateral,-pip_lateral,pip_out> }

	//3 on left side
	object { pip translate <-pip_out,-pip_lateral,pip_lateral> }
	object { pip translate <-pip_out,0,0> }
	object { pip translate <-pip_out,pip_lateral,-pip_lateral> }

	//4 on right side
	object { pip translate <pip_out,-pip_lateral,pip_lateral> }
	object { pip translate <pip_out,-pip_lateral,-pip_lateral> }
	object { pip translate <pip_out,pip_lateral,pip_lateral> }
	object { pip translate <pip_out,pip_lateral,-pip_lateral> }

	//5 on front
	object { pip translate <pip_lateral,pip_lateral,-pip_out> }
	object { pip translate <-pip_lateral,-pip_lateral,-pip_out> }
	object { pip translate <0,0,-pip_out> }
	object { pip translate <-pip_lateral,pip_lateral,-pip_out> }
	object { pip translate <pip_lateral,-pip_lateral,-pip_out> }

	//6 on bottom
	object { pip translate <-pip_lateral,-pip_out,-pip_lateral>}
	object { pip translate <0,-pip_out,-pip_lateral>}
	object { pip translate <pip_lateral,-pip_out,-pip_lateral>}
	object { pip translate <-pip_lateral,-pip_out,pip_lateral>}
	object { pip translate <0,-pip_out,pip_lateral>}
	object { pip translate <pip_lateral,-pip_out,pip_lateral>}

}

#ifndef (randomRot)
	#declare randomRot = seed(99);
#end

#macro facedie6(theFace)
	object { die6
		#switch (theFace)
			#case (1)
				#break
			#case (2)
				rotate <-90,0,0>
				#break
			#case (3)
				rotate <0,0,-90>
				#break
			#case (4)
				rotate <0,0,90>
				#break
			#case (5)
				rotate <90,0,0>
				#break
			#case (6)
				rotate <180,0,0>
				#break
		#end
		rotate <0,rand(randomRot)*360,0>
	}
#end

//#declare die8rotate = 35.26438968275;
#declare die8rotate = 180/5;
#declare die8 = difference {
	intersection {
		plane { z, 1 rotate < die8rotate, 0, 0>} //8
		plane { z, 1 rotate <-die8rotate, 0, 0>} //5
		plane {-z, 1 rotate < die8rotate, 0, 0>} //1
		plane {-z, 1 rotate <-die8rotate, 0, 0>} //4
   
		plane { x, 1 rotate <0, 0, -die8rotate>} //6
		plane { x, 1 rotate <0, 0,  die8rotate>} //7
		plane {-x, 1 rotate <0, 0, -die8rotate>} //3
		plane {-x, 1 rotate <0, 0,  die8rotate>} //2
	}

	//the numbers
	#declare textindent = 1-text_depth/2;
	union {
		object { textnumber[1]
			translate <-textextent[1].x/2,-textextent[1].y/2,0>
			translate <0,0,-textindent-.02>
			rotate <die8rotate,0,0>
		}
		object { textnumber[2]
			translate <-textextent[2].x/2,-textextent[2].y/2,0>
			scale <-1,-1,1>
			rotate <0,90,0>
			translate <-1-text_depth/2,0,0>
			rotate <0,0,die8rotate>
		}
		object { textnumber[3]
			translate <-textextent[3].x/2, -textextent[3].y/2,0>
			rotate <0,90,0>
			translate <-1-text_depth/2,0,0>
			rotate <0,0,-die8rotate>
		}
		object { textnumber[4]
			translate <-textextent[4].x/2,-textextent[4].y/2,0>
			scale <-1,-1,1>
			translate <0,0,-textindent-.02>
			rotate <-die8rotate,0,0>
		}
		object { textnumber[5]
			translate <-textextent[5].x/2, -textextent[5].y/2,0>
			scale <-1,1,1>
			translate <0,0,textindent>
			rotate <-die8rotate,0, 0>
		}
		object { textnumber[6]
			translate <-textextent[6].x/2, -textextent[6].y/2,0>
			scale <1,-1,1>
			rotate <0,90,0>
			translate <textindent,0,0>
			rotate <0,0,-die8rotate>
		}
		object { textnumber[7]
			translate <-textextent[7].x/2,-textextent[7].y/2,0>
			scale <-1,1,1>
			rotate <0,90,0>
			translate <textindent,0,0>
			rotate <0,0, die8rotate>
		}
		object { textnumber[8]
			translate <-textextent[8].x/2, -textextent[8].y/2,0>
			scale <-1,-1,1>
			translate <0,0,textindent>
			rotate <die8rotate,0,0>
		}

		material {
			dienumber
		}
	}
	bounded_by { sphere { <0,0,0>,1.7} }
}

#macro facedie8(theFace)
	object { die8
		#switch (theFace)
			#case (1)
				rotate <0,180,0>
				#break
			#case (2)
				rotate <0,0,180>
				rotate <0,-90,0>
				#break
			#case (3)
				rotate <0,90,0>
				#break
			#case (4)
				rotate <0,0,180>
				rotate <0,180,0>
				#break
			#case (5)
				#break
			#case (6)
				rotate <0,0,180>
				rotate <0,90,0>
				#break
			#case (7)
				rotate <0,-90,0>
				#break
			#case (8)
				rotate <0,0,180>
				#break
		#end
		rotate <-(90-die8rotate),0,0>
		translate <0,tan(radians(die8rotate)),0>
		rotate <0,rand(randomRot)*360,0>
	}
#end


// Twenty-sided dice
// 6/1995 Christian Perle <christian.perle@tu-clausthal.de>
// POV version: 2.0 or higher
// Copying policy: LGPL (see file COPYING)

#declare Cscl = <1/14, 1/14, 1/100>;

#declare Eins = object {
  char_1
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate <52.6625, 0, 0>
}

#declare Zwei = object {
  char_2
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate -60*z
  rotate <-52.6625, -252, 0>
}

#declare Drei = object {
  char_3
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate -120*z
  rotate <52.6625, -144, 0>
}

#declare Vier = object {
  char_4
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate 60*z
  rotate <-52.6625, -36, 0>
}

#declare Fuenf = object {
  char_5
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate 120*z
  rotate <-10.8125, -324, 0>
}

#declare Sechs = union {
  object { char_6 }
  cylinder { <2.2, .4, 0>, <2.2, .4, 1>, .4 }
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate <-10.8125, -108, 0>
}

#declare Sieben = object {
  char_7
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate 120*z
  rotate <52.6625, -288, 0>
}

#declare Acht = object {
  char_8
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate <-10.8125, -180, 0>
}

#declare Neun = union {
  object { char_9 }
  cylinder { <2.2, .4, 0>, <2.2, .4, 1>, .4 }
  translate <0, -2.5, -.5>
  scale Cscl
  translate -1*z
  rotate 180*z
  rotate <10.8125, -72, 0>
}

#declare Zehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_0 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate -60*z
  rotate <10.8125, -216, 0>
}

#declare Elf = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_1 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate -120*z
  rotate <-10.8125, -36, 0>
}

#declare Zwoelf = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_2 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate <-10.8125, -252, 0>
}

#declare Dreizehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_3 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate 180*z
  rotate <10.8125, 0, 0>
}

#declare Vierzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_4 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate 60*z
  rotate <-52.6625, -108, 0>
}

#declare Fuenfzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_5 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate 180*z
  rotate <10.8125, -288, 0>
}

#declare Sechzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_6 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate 60*z
  rotate <10.8125, -144, 0>
}

#declare Siebzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_7 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate 120*z
  rotate <52.6625, -216, 0>
}

#declare Achtzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_8 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate -60*z
  rotate <-52.6625, -324, 0>
}

#declare Neunzehn = union {
  object { char_1 translate <-2, -2.5, -.5> }
  object { char_9 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate -120*z
  rotate <52.6625, -72, 0>
}

#declare Zwanzig = union {
  object { char_2 translate <-2, -2.5, -.5> }
  object { char_0 translate <2, -2.5, -.5> }
  scale Cscl
  translate -1*z
  rotate -60*z
  rotate <-52.6625, -180, 0>
}

// 20-Seitiger W"urfel
#declare die20 = union {
  object { Icosahedron }
  union {
    object { Eins }
    object { Zwei }
    object { Drei }
    object { Vier }
    object { Fuenf }
    object { Sechs }
    object { Sieben }
    object { Acht }
    object { Neun }
    object { Zehn }
    object { Elf }
    object { Zwoelf }
    object { Dreizehn }
    object { Vierzehn }
    object { Fuenfzehn }
    object { Sechzehn }
    object { Siebzehn }
    object { Achtzehn }
    object { Neunzehn }
    object { Zwanzig }
	material { dienumberwhite }
  }
 // rotate 34.3375*x  // die '1' Seite nach oben
  //translate .4*y
}

#macro facedie20(theFace)
	#declare rotateLowerUp =  45; //52.6625;
	#declare rotateOneUp = 38;
	#declare rotateTwentyUp = 180+rotateOneUp
	#declare rotateTriangle = 120;
	object { die20
		#switch (theFace)
			#case (1)
				rotate <rotateOneUp,0,0>
				#break
			#case (2)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (3)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (4)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (5)
				rotate <rotateOneUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (6)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (7)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (8)
				rotate <rotateTwentyUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (9)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0>
				rotate <0,180,0>
				#break
			#case (10)
				rotate <rotateTwentyUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (11)
				rotate <rotateOneUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (12)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (13)
				rotate <rotateOneUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (14)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (15)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (16)
				rotate <rotateTwentyUp,0,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (17)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (18)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle*2,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (19)
				rotate <rotateOneUp,0,0>
				rotate <0,rotateTriangle,0>
				rotate <rotateLowerUp,0,0>
				rotate <0,180,0>
				#break
			#case (20)
				rotate <rotateTwentyUp,0,0>
				rotate <0,rotateTriangle,0>
				#break	
		#end
		translate <0,1,0>
		rotate <0,rand(randomRot)*360,0>
	}

#end


//a 4-sider
#declare pside=1;
#declare pslice=sqrt(pside*pside - pside*pside/4);
#declare pcenter = (pside/2)*tan(radians(30));
#declare textscale = .3;
#declare pheight = pslice*pslice/(pside*pside);

#declare die4_1 = object { textnumber[1]
	material { dienumber }
	scale textscale
}
#declare die4_2 = object { textnumber[2]
	material { dienumber }
	scale textscale
}
#declare die4_3 = object { textnumber[3]
	material { dienumber }
	scale textscale
}
#declare die4_4 = object { textnumber[4]
	material { dienumber }
	scale textscale
}

#declare bottomrotate = <-24,0,0>;
#declare leftsiderotate = bottomrotate - <1,0,0>;
#declare botmargin = .04;
#declare leftmargin = botmargin*3;
#declare die4 = union {
	union {
		union {
			prism {
				linear_spline
				conic_sweep
				0.0, 	//Base height
				1.0, 	//Top height
				4,
				<pside/2,   pcenter>,
				<-pside/2,   pcenter>,
				<0, -(pslice-pcenter)>,
				<pside/2,   pcenter>
				//sturm
				scale <1,-1,1>
				translate <0,1,0>
				scale <1,pheight,1>
			}
			//the 1-4-2 side (rotate 180 to see)
			object { die4_1
				translate <0,botmargin,0>
				rotate bottomrotate
				translate <-textscale*textextent[1].x/2,0,pcenter+text_depth/2>
			}
			object { die4_4
				rotate <0,0,60>
				scale <1,-1,1>
				translate <pside/3.5-leftmargin,pheight/2,pcenter+text_depth/2>
				rotate leftsiderotate
			}
			object { die4_2
				rotate <0,0,120>
				scale <-1,1,1>
				translate <-pside/2.8+leftmargin,pheight/3,pcenter+text_depth/2>
				rotate leftsiderotate
			}
			rotate <0,120,0>
		}
		//the 1-3-4 side
		object { die4_1
			translate <0,.08,0>
			rotate bottomrotate
			translate <-textscale*textextent[1].x/2,0,pcenter+text_depth/2>
		}
		object { die4_3
			rotate <0,0,60>
			scale <1,-1,1>
			translate <pside/3.5-leftmargin,pheight/2,pcenter+text_depth/2>
			rotate leftsiderotate
		}
		object { die4_4
			rotate <0,0,120>
			scale <-1,1,1>
			translate <-pside/2.8+leftmargin,pheight/3,pcenter+text_depth/2>
			rotate leftsiderotate
		}
		rotate <0,120,0>
	}
	//the 1-2-3 side
	object { die4_1
		translate <0,.08,0>
		rotate bottomrotate
		translate <-textscale*textextent[1].x/2,0,pcenter+text_depth/2>
	}
	object { die4_2
		rotate <0,0,60>
		scale <1,-1,1>
		translate <pside/3.5-leftmargin,pheight/2,pcenter+text_depth/2>
		rotate leftsiderotate
	}
	object { die4_3
		rotate <0,0,120>
		scale <-1,1,1>
		translate <-pside/2.8+leftmargin,pheight/3,pcenter+text_depth/2>
		rotate leftsiderotate
	}
	//rotate <0,120,0>
	scale 3.5
}

#macro facedie4(theFace)
	object { die4
		translate <0,-1,0>
		#switch (theFace)
			#case (1)
				rotate <0,60,0>
				#break
			#case (2)
				rotate <0,0,120>
				#break
			}
		#end
		translate <0,1,0>
	}
#end


//die12
#declare sideCount = 5;
#declare circumScribeR = 1;
#declare topPoint = <0,0,circumScribeR>;
#declare topVert = topPoint;
#declare rightTopVert = vrotate(topPoint,<0,-360/sideCount,0>);
#declare leftTopVert = vrotate(topPoint,<0,360/sideCount,0>);
#declare rightBotVert = vrotate(topPoint,<0,-360/sideCount*2,0>);
#declare leftBotVert = vrotate(topPoint,<0,360/sideCount*2,0>);
#declare rightX = rightTopVert.x;
#declare sideLength = rightBotVert.x-leftBotVert.x;
#declare inScribeR = topVert.z-rightBotVert.z-circumScribeR;
#declare bendAngle = degrees(asin(2/sqrt(5)));
#declare highUp = topVert + <0,0,inScribeR>;
#declare highUp = vrotate(highUp,<180,0,0>);
#declare highUp = vrotate(highUp,<bendAngle,0,0>);
#declare lowUp = rightTopVert+<0,0,inScribeR>;
#declare lowUp = vrotate(lowUp,<180,0,0>);
#declare lowUp = vrotate(lowUp,<bendAngle,0,0>);
#declare partUp = highUp.y+lowUp.y;

#declare theSide = polygon {
	sideCount+1,
	leftBotVert,
	rightBotVert,
	rightTopVert,
	topVert,
	leftTopVert,
	leftBotVert
}

#declare bendSide = transform {
	translate <0,0,inScribeR>
	rotate <180,0,0>
	rotate <bendAngle,0,0>
	translate <0,0,-inScribeR>
}

#declare bentSide = 	object { theSide
	transform { bendSide }
}

#declare botOrder = array[5][2] {
	{8,-36},
	{10,-36},
	{11,36},
	{9,36},
	{7,180}
}
#declare topOrder = array[5][2] {
	{2,-36},
	{4,-36},
	{6,180},
	{5,36},
	{3,36}
}

#declare dieBottom = union {
	union {
		object { theSide }
		object { textnumber[12]
			translate <-textextent[12].x/2,-textextent[12].y/2,0>
			rotate <90,0,0>
			scale <-1,1,1>
			translate <0,0,-.001>
			material { dienumberwhite }
		}
	}

	#declare siding = 0;
	#while (siding < sideCount)
		union {
			object { bentSide }
			#declare theNumber = botOrder[siding][0];
			#declare theAngle = botOrder[siding][1];
			object { textnumber[theNumber]
				translate <-textextent[theNumber].x/2,-textextent[theNumber].y/2,0>
				rotate <90,0,0>
				rotate <0,theAngle,0>
				scale <-1,1,-1>
				transform { bendSide }
				translate <0,0,-.001>
				material { dienumberwhite }
			}
			rotate <0,-360/sideCount*siding,0>
		}
		#declare siding = siding + 1;
	#end
}
#declare dieTop = union {
	union {
		object { theSide }
		object { textnumber[1]
			translate <-textextent[1].x/2,-textextent[1].y/2,0>
			rotate <90,0,0>
			scale <1,1,1>
			rotate <0,144,0>
			translate <0,0,-.001>
			material { dienumberwhite }
		}
	}

	#declare siding = 0;
	#while (siding < sideCount)
		union {
			object { bentSide }
			#declare theNumber = topOrder[siding][0];
			#declare theAngle = topOrder[siding][1];
			object { textnumber[theNumber]
				translate <-textextent[theNumber].x/2,-textextent[theNumber].y/2,0>
				rotate <90,0,0>
				rotate <0,theAngle,0>
				scale <1,1,-1>
				transform { bendSide }
				translate <0,0,-.001>
				material { dienumberwhite }
			}
			rotate <0,-360/sideCount*siding,0>
		}
		#declare siding = siding + 1;
	#end
}

#declare die12 = union {
	object { dieBottom }
	object { dieTop
		scale <1,-1,1>
		translate <0,partUp,0>
		rotate <0,360/sideCount/2,0>
	}
	scale 1/partUp
}

#macro facedie12(theFace)
	#declare rotateOnce = 360/5;
	object { die12
		translate <0,-.5,0>
		#switch (theFace)
			#case (1)
				rotate <0,180,0>
				#break
			#case (2)
				rotate <0,180,0>
				rotate <0,rotateOnce*2,0>
				rotate <bendAngle,0,0>
				rotate <0,rotateOnce/2,0>
				#break
			#case (3)
				rotate <0,180,0>
				rotate <0,rotateOnce,0>
				rotate <bendAngle,0,0>
				rotate <0,-rotateOnce/2,0>
				#break
			#case (4)
				rotate <0,180,0>
				rotate <0,-rotateOnce*2,0>
				rotate <bendAngle,0,0>
				rotate <0,rotateOnce/2,0>
				#break
			#case (5)
				rotate <0,180,0>
				rotate <bendAngle,0,0>
				rotate <0,-rotateOnce/2,0>
				#break
			#case (6)
				rotate <0,180,0>
				rotate <0,-rotateOnce,0>
				rotate <bendAngle,0,0>
				rotate <0,180,0>
				#break
			#case (7)
				rotate <0,0,180>
				rotate <0,rotateOnce,0>
				rotate <bendAngle,0,0>
				rotate <0,180,0>
				#break
			#case (8)
				rotate <0,0,180>
				rotate <bendAngle,0,0>
				rotate <0,rotateOnce/2,0>
				#break
			#case (9)
				rotate <0,0,180>
				rotate <0,rotateOnce*2,0>
				rotate <bendAngle,0,0>
				rotate <0,-rotateOnce/2,0>
				#break
			#case (10)
				rotate <0,0,180>
				rotate <0,rotateOnce*4,0>
				rotate <bendAngle,0,0>
				rotate <0,rotateOnce/2,0>
				#break
			#case (11)
				rotate <0,0,180>
				rotate <0,rotateOnce*3,0>
				rotate <bendAngle,0,0>
				rotate <0,-rotateOnce/2,0>
				#break
			#case (12)
				rotate <0,0,180>
				#break
		#end
		translate <0,.5,0>
		rotate <0,rand(randomRot)*360,0>
	}
#end

