//	Persistence of Vision Ray Tracer Scene Description File
//use MegaPOV 1.2.1'

//3344x2508 for 300 dpi (1975x1531 after smart trim)
//1600x1200 for 100% (1163x900 after trim)
//layout in line with text
//adaptive; threshold 0.5, recursion 3, jitter 0.5

#include "colors.inc"
#include "sheet.inc"
#include "dice.inc"
#include "pencil.inc"

global_settings {
	charset utf8
}

camera {
	perspective 
	location <0,5.5,-5>
	look_at <0,0,0>
}
light_source {
	<60, 100, -100>
	White
}

background {
	rgb <1, 1, 1>
}

//00B4 is the utf8 accent acute
//0301 is the utf8 accent acute combining
//142 is the accented e on the Macintosh (in decimal)
#declare characterName = "Charlotte Korde"
#declare characterAccent = chr(11*16+4)
#declare abilities = array[8][2] {
	{"Charisma", "17"},
	{"Wisdom","15"},
	{"Agility","8"},
	{"Endurance","10"},
	{"Intelligence","12"},
	{"Strength","9"},
	{"", ""},
	{"Mojo", "13"}
}
#declare saves = array[7][2] {
	{"Reactions",""},
	{"Perception","8"},
	{"Willpower","8"}
	{"Evasion","3"},
	{"Fortitude","4"},
	{"Health","4"},
	{"Reason","6"},
}

#declare characterInfo = array[8][2] {
	{"Moral Code","Good"},
	{"Age","36"},
	{"Height","5' 1\""},
	{"Weight","93 lbs"},
	{"Level","1"},
	{"", ""},
	{"Survival","5 llll"},
	{"Verve", "7 lll"}
}

#declare specialAbilities = array[8][2] {
	{"Special Abilities",""},
	{"Archetype","Monk"},
	{"Species","Half-Elven"},
	{"Night vision", ""},
	{"Sleep/charm", "+1"},
	{"Psychic Pool","1+"},
	{"", ""},
	{"Silver","25"}
}

#declare OccSkills = array[9][2] {
	{"Fields and Skills",""},
	{"Native Culture","+2 Crosspoint etiquette"},
	{"Language Science","+1 Anglish, Frankish, literacy"},
	{"Performance Art","+1 acting"},
	{"Personality Art","+1 demagoguery, mediation"},
	{"Engineering Science","+1 clockworks"},
	{"Telepathic Art","+5 illusion"},
	{"Psychokinetic Craft","+3 telekinesis"},
	{"Fighting Art","+0 quarterstaff"}
}

//character sheet
object { makeSheet()
	rotate <90,0,0>
}

//plane {
//	y,0
//	texture { paperMat }
//}


//4d6
union {
	object {
		facedie6(2)
		material { diered }
		translate <-3.5,0,-1>
	}
	object {
		facedie6(6)
		material { diered }
		translate <-1,0,0>
	}
	object {
		facedie6(4)
		material { diered }
		translate <1.5, 0, .5>
	}
	object {
		facedie6(3)
		material { diered }
		translate <.2, 0, -3>
	}
	translate <0,1,0>
	scale .19
	translate <-2,0,1>
}

//twenty-sider
object { die20
	rotate <-90,0,0>
	translate <0,1,0>
	scale .19
	material { diegreen }
	rotate <0,150,0>
	translate <2,0,-1>
}

object { aPencil
	rotate <0,40,0>
	translate <.75,0,-.6>
}

plane {
	y,0
	
	pigment {
		color White
	}
	finish {
		ambient paperAmbient
		diffuse 1000
	}
	translate <0,-.01,0>
}