#include "colors.inc"

#ifndef (NoFunctions)
#include "functions.inc"
#end

#declare delta = .001;
#declare paperWidth = 8.5;
#declare marginWidth = 1;
#declare punchHoleLeft = -paperWidth/2+marginWidth/2;
#declare punchThickness = .2;
#declare leftColumn = -.7;
#declare rightColumn = 1;
#declare paperAmbient = .4;

#declare paperColor = rgb <1,1,0>;
#declare ruleColor = rgb <0,1,0>;

#declare graphpaperColor = rgb <0.8,1,0.5>;
#declare graphruleColor = rgb <0,0,0>;
#declare graphTypeHex = 1;
#declare graphTypeSquare = 2;

#declare ruleThickness = .01;
#declare paperThickness = .001;
#declare inkThickness = 0.0029;
#declare penThickness = 2*inkThickness;
#declare lineSize = .18;
//JeninesHand has a bad 'y'
//#declare writingFont = "JeninesHand.ttf"
//#declare writingFont = "GeorgesH.ttf"
#declare writingFont = "Architect.ttf"
#declare printedFont = "timrom.ttf"
#declare TCENTER = 1;
#declare TLEFT = 0;
#declare TRIGHT = 2;
#declare paperNorm = normal {
	wrinkles .2
}

#declare verticalRule = texture {
	pigment {
		gradient x
		color_map {
			[0 ruleColor]
			[ruleThickness/paperWidth ruleColor]
			[ruleThickness*2/paperWidth rgbf 1]
			[1 rgbf 1]
		}
		scale <paperWidth,1,1>
		translate <-1.5,0,0>
	}
	normal { paperNorm }
	
	finish {
		ambient paperAmbient
	}
}

#declare paperMat = texture {
	pigment {
		gradient y
		color_map {
			[0 ruleColor]
			[ruleThickness/lineSize ruleColor]
			[ruleThickness*2/lineSize paperColor]
			[1 paperColor]
		}
		scale lineSize
		translate <0,19.95,0>
	}
	normal {paperNorm}
	finish {
		ambient paperAmbient
	}
}
texture {
	verticalRule
}


#declare unruledPaper = texture {
	pigment {
		color paperColor
	}
	normal {paperNorm}
	finish {
		ambient paperAmbient
	}
}
texture {
	verticalRule
}


#declare graphVert = pigment {
	gradient y
	color_map {
		[0 graphruleColor]
		[ruleThickness/lineSize graphruleColor]
		[ruleThickness*2/lineSize graphpaperColor]
		[1 graphpaperColor]
	}
	scale lineSize
	translate <0,19.95,0>
}
#declare graphHoriz = 	pigment {
	gradient x
	color_map {
		[0 graphruleColor]
		[ruleThickness/lineSize graphruleColor]
		[ruleThickness*2/lineSize graphpaperColor]
		[1 graphpaperColor]
	}
	scale lineSize
	translate <19.95,0,0>
}

#declare graphMat = texture {
	pigment {
		average
		pigment_map {
			[1.0 graphVert]
			[1.0 graphHoriz]
		}
	}
	normal {paperNorm}
	finish {
		ambient paperAmbient
	}

}

#ifndef (NoFunctions)

#declare hexChange = .09;
#declare hexMat = texture {
	pigment {
		function { f_hex_x(x,y,z,0)}
		colour_map {
			[0 graphpaperColor]
			[1-ruleThickness*2/hexChange graphpaperColor]
			[1-ruleThickness/hexChange graphruleColor]
			[1	graphruleColor]
		}
		scale hexChange
	}
	normal { paperNorm }
	finish {
		ambient paperAmbient
	}
}

#end

#declare inkMat = material {
	texture {
		pigment {
			color Black
		}
		normal {paperNorm}
		finish {
			ambient paperAmbient
			phong .5
			phong_size 60
		}
	}
}
#macro makeTextBox(theText,textAlign,textFont,textThickness)
	#local theTextObj = text {
		ttf textFont
		theText
		textThickness, 0
	}
	#local theTextMax = max_extent(theTextObj);
	object { theTextObj
		#switch (textAlign)
			#case (TCENTER)
				translate <-theTextMax.x/2,0,0>
				#break
			#case (TRIGHT)
				translate <-theTextMax.x,0,0>
				#break
		#end
		translate <0,0,-textThickness>
	}
#end

#macro makeUnitTextBox(theText,textAlign,textFont,textThickness)
	#local theTextObj = text {
		ttf textFont
		theText
		textThickness, 0
	}
	#local theTextMax = max_extent(theTextObj);
	object { theTextObj
		scale <1/theTextMax.x,1/theTextMax.x,1>
		#switch (textAlign)
			#case (TCENTER)
				translate <-.5,0,0>
				#break
			#case (TRIGHT)
				translate <-1,0,0>
				#break
		#end
		translate <0,0,-textThickness>
	}
#end

#macro makeUnitTextAccented(theText1, textAccent, textAlign,textFont,textThickness)
	#local theTextObj = text {
		ttf textFont
		theText1
		textThickness, 0
	}
	#local theAccent = text {
		ttf textFont
		textAccent
		textThickness, 0
	}
	#local theTextMax = max_extent(theTextObj);
	union {
		object { theTextObj }
		object { theAccent
			translate <theTextMax.x, 0, 0>
		}
		scale <1/theTextMax.x,1/theTextMax.x,1>
		#switch (textAlign)
			#case (TCENTER)
				translate <-.5,0,0>
				#break
			#case (TRIGHT)
				translate <-1,0,0>
				#break
		#end
		translate <0,0,-textThickness>

	}
#end

#macro makeStatPair(StatName,StatValue)
	#local leftSide = object {
		#if (strlen(StatValue) > 0)
			#local StatName = concat(StatName,":")
		#end
		makeTextBox(StatName,TRIGHT,printedFont,inkThickness)
	}
	#local leftSideMax = max_extent(leftSide);
	union {
		object { leftSide
			#if (strlen(StatValue) = 0)
				translate <2,0,0>
			#end
		}
		#if (strlen(StatValue) > 0)
			#local rightSide = object {
				makeUnitTextBox(StatValue,TLEFT,writingFont,penThickness)
			}
			#local rightSideMax = max_extent(rightSide);
			#local theScale = leftSideMax.y/rightSideMax.y*1.2;
			object { rightSide
				scale <theScale,theScale,penThickness/inkThickness>
				translate <.6,0,0>
			}
		#end
	}
#end

#macro makeTextArray(theArray)
	#local itemCount = dimension_size(theArray,1);
	#local currentItem = 0;
	#local itemDrop = 0;
	#while (currentItem < itemCount)
		#local theObj = object {
			makeStatPair(theArray[currentItem][0], theArray[currentItem][1])
		}
		#local itemsMax = max_extent(theObj);
		object { theObj
			scale <.15,.15,1>
			translate <0,-itemDrop,0>
		}
		#declare itemDrop = itemDrop + lineSize;
		#declare currentItem = currentItem+1;
	#end
#end

#macro makeSheet()
	union {
		union {
			object {
				#ifndef (characterAccent)
					makeUnitTextBox(characterName,TCENTER,writingFont,penThickness)
				#else
					makeUnitTextAccented(characterName,characterAccent, TCENTER,writingFont,penThickness)
				#end
				scale <2.5,2.5,1>
				translate <0,11*lineSize,0>
			}
			
			union {
				union {
					makeTextArray(abilities)
					translate <leftColumn,9*lineSize,0>
				}
				
				union {
					makeTextArray(saves)
					translate <leftColumn,0*lineSize,0>
				}
				
				union {
					makeTextArray(characterInfo)
					translate <rightColumn,9*lineSize,0>
				}
				
				union {
					makeTextArray(specialAbilities)
					translate <rightColumn,0*lineSize,0>
				}
				
				union {
					makeTextArray(OccSkills)
					translate <leftColumn/2,-8*lineSize,0>
				}
				translate <.25,0,0>
	
			}
	
			material {
				inkMat
			}
			translate <0,2*lineSize,0>
		}
		
		difference {
			union {
				box {
					<-paperWidth/2,4.5,0>,<paperWidth/2,5.5,paperThickness>
					texture {
						unruledPaper
						scale <2,2,1>
					}
				}
				box {
					<-paperWidth/2,-5.5,0>,<paperWidth/2,4.5,paperThickness>
				}
			}
			cylinder {
				<punchHoleLeft,0,-delta>,<punchHoleLeft,0,paperThickness+delta>,punchThickness
			}
			cylinder {
				<punchHoleLeft,-4.5,-delta>,<punchHoleLeft,-4.5,paperThickness+delta>,punchThickness
			}
			cylinder {
				<punchHoleLeft,4.5,-delta>,<punchHoleLeft,4.5,paperThickness+delta>,punchThickness
			}
			scale <.5,.5,1>
			texture {
				paperMat
			}
		}
	}
#end

#macro makeGraph(graphType)
	#ifndef(graphType)
		#local graphType = graphTypeSquare
	#end
	difference {
		box {
			<-paperWidth/2,-5.5,0>,<paperWidth/2,5.5,paperThickness>
		}

		cylinder {
			<punchHoleLeft,0,-delta>,<punchHoleLeft,0,paperThickness+delta>,punchThickness
		}
		
		cylinder {
			<punchHoleLeft,-4.5,-delta>,<punchHoleLeft,-4.5,paperThickness+delta>,punchThickness
		}
		cylinder {
			<punchHoleLeft,-3.5,-delta>,<punchHoleLeft,-3.5,paperThickness+delta>,punchThickness
		}
		
		cylinder {
			<punchHoleLeft,4.5,-delta>,<punchHoleLeft,4.5,paperThickness+delta>,punchThickness
		}
		cylinder {
			<punchHoleLeft,3.5,-delta>,<punchHoleLeft,3.5,paperThickness+delta>,punchThickness
		}
		
		scale <.5,.5,1>
		texture {
			#if (graphType = graphTypeHex)
				hexMat
			#else
				graphMat
			#end
		}
	}

#end