//1 unit = 1 inch
//-x is west
//+z is north
#version unofficial MegaPov 1.21;
//2666x1500 for 300 dpi and 640x360 pts
//746x420  for 72 dpi, 5.51x9.7 inches wide
//PNG 8 bit
//anti-aliasing 2, threshold .5, recursion 2, jitter .5

#declare totalspan=360;
#declare notexture=0;
#include "pandora.inc"
#declare DEM_Scale = 215009.843750;
#include "stuff.inc"
#include "moon.inc"

//ambient light sources
#declare ambientlight = color rgb <.9,.9,1.2>*.3;
light_source {
	<-500*miles,500*miles,0>
	color ambientlight
	shadowless
	media_interaction off
}
light_source {
	<0,500*miles,500*miles>
	color ambientlight
	shadowless
	media_interaction off
}
light_source {
	<0,500*miles,-500*miles>
	color ambientlight
	shadowless
	media_interaction off
}
#declare observer_height = 6*feet;


camera {
	location <-13*feet,observer_height,-13*feet>
	look_at <0,top_floor_level+observer_height/2,0>
	
	right x*image_width/image_height
}

object { temple
	rotate <0,4,0>
}

//grass around the temple
#include "grasspatch.inc"
#declare Patch_Shape = 0;
#declare Clump_Radius_Minimum = 98.6;
#declare Clump_Radius_Maximum = 100.2;
#declare Blade_Scale = 5;
#declare Blade_Density = .14;
#declare Spread_Correction = 0.3;
union {
	PlantPatch()
}

//another patch for flavor
//we'll copy this one all over
#declare Patch_Shape = 3;
#declare Clump_Radius_Minimum = 40.6;
#declare Clump_Radius_Maximum = 42.2;
#declare Blade_Scale = 5;
#declare Blade_Density = .16;
#declare Spread_Correction = 0.3;
#declare grasscurve = union {
	PlantPatch()
}

object { grasscurve
	translate <120, 0, 360>
}

object { grasscurve
	translate <360, 0, 720>
}

object { grasscurve
	translate <330, 0, 1720>
}

object { grasscurve
	translate <390, 0, 0>
}


#declare moonRadius = 173800;
#declare earth2moon = 38450000/10;
#declare earth2sun = 0;
#declare earthRadius = 637800;
#declare earthOffset = -earthRadius - 450000;

#declare moon_location = transform {
	translate <0,0,earth2moon>
	rotate <0,49,25>
	translate <0,0,earth2sun-earthOffset>
	rotate <3,0,0>
	rotate <0,35,0>
}

//moonlight
light_source {
	<0,0,0>
	color rgb <.75,.75,1>
	transform { moon_location }
}

object { Moon
	scale moonRadius
	scale 1.5
	transform {moon_location}
	no_shadow
}

#declare sundial_height = column_part_height*1.5;
#declare sundial_platform_radius = column_diameter*2;
#declare sundial_red = material {
	texture {
		finish {
			ambient .5
			diffuse 0
			reflection 0.5
			phong 0.3
			phong_size 60
		}
		pigment {
			color Red
			filter .25
		}
	}
}
#declare sundial_black = material {
	texture {
		pigment {
			agate
			color_map {
				[ 0.0 rgb <0, 0, 0> ]
				[ 1.0 rgb <0.609995, 0.000015, 0.000015> ]
			}
			scale 4
		}
		normal { crackling }
		finish {
			reflection rgb <.5, .5, .5>
			phong .7
			phong_size 20
			ambient .5
		}
	}
}

union {
	//the sundial's pillar
	cone { 
		<0,0,0>,sundial_height/6
		<0,sundial_height,0>, sundial_height/18
		//#local quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
		//texture { terrace_texture translate quarry_loc}
		material { sundial_black }
	}
	
	sphere {
		<0,sundial_height*3/4,0>,sundial_height/4
		
		material { sundial_black }
	}

	union {
		//the sundial's table
		cylinder {
			<0,0,0>,<0,column_part_height/10,0>,sundial_platform_radius
			#local quarry_loc = <rand(Quarry),rand(Quarry),rand(Quarry)>*Quarry_Size;
			texture { terrace_texture
				translate quarry_loc
				//scale 4
				rotate <0,99,100>
			}
		}
		
		//the digits of the sundial
		#declare clock_count = 0;
		#declare clock_digits = array[12] {"I","II","III","IV","V","VI","VII","VIII","IX","X","XI","XII"}
		#while (clock_count < 12)
			text {
				ttf "geneva",
				clock_digits[clock_count]
				column_part_height/10, 0
				h_align_center
				rotate <90,0,0>
				#declare rotation = 360*(clock_count+1)/12;
				rotate <0,-rotation,0>
				translate <0,0,-.2-.8*(1-sin(radians(rotation/2)))>
				scale <5,1,5>
				translate <0,column_part_height/9,0>
				translate <0,0,sundial_platform_radius>
				rotate <0,rotation,0>
				material { sundial_red }
			}
			#declare clock_count= clock_count + 1;
		#end
		
		//the gnomon
		prism {
			linear_spline
			linear_sweep
			0.0, 	//Base height
			column_part_height/20, 	//Top height
			6,
			<1, 0>,
			<-.88, .88>,
			<-.88, .77>,
			<-0.06666, 0.33333>,
			<0, 0>,
			<1, 0>
			material { sundial_red }
			scale <6,1,6>
			rotate <-90,0,0>
			rotate <0,90,0>
			translate <0,column_part_height/10,0>
		}

		
		//move it up to the top of the pillar
		translate <0,sundial_height,0>
	}
	translate <0,top_floor_level,0>
}

background {
	color White
}

//sky
sky_sphere {
	pigment {
		gradient y
		turbulence .001
		color_map {
			[0.0	color <1,1,0>]
			[0.00125	color <1,1,0>]
			[0.003	color <1,0,0>]
			[0.005	color <.25,.2,.85>]
			[.75	color <.1,.1,.65>]
			[.95	color <.1,.1,.5>]
			[1.0	color <0,0,0>]
		}
		scale 2
		translate -1
		rotate <-90,-90,0>
	}
	pigment {
		granite
		color_map {
			[ 0.000  0.270 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
			[ 0.270  0.280 color rgbf <.5,.5,.4, 0> color rgbf <.8,.8,.4, 0> ]
			[ 0.280  0.470 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
			[ 0.470  0.480 color rgbf <.4,.4,.5, 0> color rgbf <.4,.4,.8, 0> ]
			[ 0.480  0.680 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
			[ 0.680  0.690 color rgbf <.5,.4,.4, 0> color rgbf <.8,.4,.4, 0> ]
			[ 0.690  0.880 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
			[ 0.880  0.890 color rgbf <.5,.5,.5, 0> color rgbf < 1, 1, 1, 0> ]
			[ 0.890  1.000 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
		}
		turbulence 1
		sine_wave
		scale .5
	}
}

height_field {
	tga "san_diego-e_pov.tga"

	texture {landscape_AL}
	translate <-0.10025, 0.000000, -0.11+.0258>
	scale <1.432607, 1.000000, 1.698626> // restore DEM aspect ratios (e,u,n)
	scale DEM_Scale // scale DEM to true size (feet)
	scale <1, 3 ,1>
	translate <0, 0*feet, 0>
	rotate <0,-30,0>
	
}