/*
A grove at night, crescent moon, with a grail lying on the ground, obscured slightly by ground fog,
three mountain peaks in the background, and mist around one of the peaks?

//2666x1500 for 300 dpi and 640x360 pts
//746x420  for 72 dpi, 5.51x9.7 inches wide
PNG 8 bit
anti-aliasing 2 (adaptive)
threshold 0.3
recursion 2
jitter 0.5
*/

global_settings {
	max_trace_level 9
}

#declare final_output = yes;
#declare use_trees = yes;
#declare use_grass = yes;
#declare nighttime = no;
#declare use_grail = yes;
#declare use_fog = no;
#declare use_mountains = yes;
#declare use_mist = yes;
#declare use_clouds = yes;

#include "colors.inc"
#include "textures.inc"
#include "moon.inc"
#include "goblet.inc"
#include "stones.inc"
#include "mountains.inc"

#declare scalefactor = 10;
#declare moonHeight = 800*scalefactor;
#declare skyHeight = 400*scalefactor;
#declare moonRadius = moonHeight/15;
#declare earthRadius = moonRadius * 20;
#declare moonRotate = <85, 10, 0>;
#declare moonLocation = vrotate(<0, moonHeight, 0>, moonRotate);
#declare moonOpposite = <-moonLocation.x, -moonLocation.y, moonLocation.z>;
#declare sunLocation = <moonLocation.x, moonLocation.y*2, -moonLocation.z>;


#declare theMoon = object { WaxingMoon
	scale moonRadius
	rotate <0, -22, -30>
	translate <0, moonHeight, 0>
	rotate moonRotate
	no_shadow
}

#declare theGround = sphere {
	0, earthRadius
	
	texture {
		groundGreen
	}
	translate <0, -earthRadius, 0>
}

#if (nighttime = yes)
	#declare starlight = .4;
	//the stars
	light_source {
		<0, 0, 0>
		color White*starlight
		translate <0, moonHeight*10, 0>
		rotate <0, 0, -50>
		shadowless
	}
	
	light_source {
		<0, 0, 0>
		color White*starlight
		translate <0, moonHeight*10, 0>
		rotate <0, 0, 50>
		shadowless
	}
	
	light_source {
		<0, 0, 0>
		color White*starlight
		translate <0, moonHeight*10, 0>
		rotate <-50, 0, 0>
		shadowless
	}
#else

	//the sun
	light_source {
		sunLocation
		color rgb <1, 1, .8>
	}
#end
	
//the "moon"
light_source {
	moonLocation
	color White*.3
	spotlight
	
	translate <0, 0, -moonRadius*1.01>
	//parallel
	point_at <0,0,0>
	radius 10
	falloff 20
	tightness 10
}

//shine on the moon
light_source {
	moonOpposite
	color White*.5
	spotlight
	cylinder
	point_at moonLocation
	radius moonRadius
	tightness 0
	falloff moonRadius*2
}


object { theMoon }

object { theGround }

//the distant forest

#if (use_trees = yes)
	#include "olive_foliage.inc"

	#declare treeScale = 24;
	#declare aTree = object { TREE
		scale treeScale
	}

	#declare treeCount = 600;
	#declare treeStuff = seed(15);
	#declare facingPool = seed(29);
	#while (treeCount > 0)
		//tree sizes are from .4 to 4 times average
		#declare treeSize = (rand(treeStuff)+.1)*2;
		//x movement is from 2 to 4 degrees from center
		#declare treeX = (rand(treeStuff)+rand(treeStuff)+rand(treeStuff)+rand(treeStuff)+rand(treeStuff)+1)*10/scalefactor;
		//rotate it around the y axis from 0 to 360 degrees
		#declare treeRotate = rand(treeStuff)*360+40;
		//rotate facing around y axis from 0 to 360 degrees
		#declare treeFacing = rand(facingPool)*360;
		
		object { aTree
			rotate <0, treeFacing, 0>
			scale treeSize
			translate <0, earthRadius, 0>
			rotate <0, 0, treeX>
			rotate <0, treeRotate, 0>
			translate <0, -earthRadius, 0>
		}
		#declare treeCount = treeCount -1;
	#end

	//far left background tree
	object { aTree
		translate <0, .75, 0>
		rotate <0, 67, 0>
		scale .35
		translate <0, earthRadius, 0>
		rotate <.5, 0, 0.4>/scalefactor
		translate <0, -earthRadius, 0>
	}
	
	
	//left background tree
	object { aTree
		translate <0, 2, 0>
		rotate <0, 50, 0>
		scale .5
		translate <0, earthRadius, 0>
		rotate <.9, 0, 0.5>/scalefactor
		translate <0, -earthRadius, 0>
	}
	
	//middle left background tree
	object { aTree
		translate <0, 2, 0>
		scale .6
		translate <0, earthRadius, 0>
		rotate <1, 0, 0.1>/scalefactor
		translate <0, -earthRadius, 0>
	}
	
	//far right background tree
	object { aTree
		translate <0, 1, 0>
		rotate <0, 100, 0>
		scale .3
		translate <0, earthRadius, 0>
		rotate <.4, 0, -0.35>/scalefactor
		translate <0, -earthRadius, 0>
	}
	
	//left foreground tree
	object { aTree
		translate <0, 1.5, 0>
		rotate <0, 33, 0>
		scale .2
		translate <0, earthRadius, 0>
		rotate <0, 0, 0.11>/scalefactor //was 0.13
		translate <0, -earthRadius, 0>
	}
	
	//tree behind the camera to the right
	object { aTree
		scale .5
		translate <0, earthRadius, 0>
		rotate <-1.4, 0, -.8>/scalefactor
		translate <0, -earthRadius, 0>
	}
#end

#if (use_clouds = yes)
	sphere {
		<0, 0, 0>, skyHeight
		pigment {
			bozo
			color_map {
				[0 rgb .8 transmit 0]
				[0.25 rgb .8 transmit .2]
				[0.3 rgb 1 transmit 1] 
				[.8 rgb .5 transmit .6]
				[1 rgb .5 transmit .5]
			}
			scale skyHeight/6
			//rotate <5, 42, 0>
			rotate <5, 52, 0>
		}
		hollow
		no_shadow
	}

#end

#if (nighttime = yes)
	//night sky
	sky_sphere {
		pigment {
			gradient y
			turbulence .001
			color_map {
				[0.0	color <1,1,0>]
				[0.00125	color <1,1,0>]
				[0.003	color <1,0,0>]
				[0.005	color <.25,.2,.85>/2]
				[.75	color <.1,.1,.65>/4]
				[.95	color <.1,.1,.5>/8]
				[1.0	color <0,0,0>]
			}
			scale 2
			translate -1
			rotate <-90,-90,0>
		}
		pigment {
			granite
			color_map {
				[ 0.000  0.270 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
				[ 0.270  0.280 color rgbf <.5,.5,.4, 0> color rgbf <.8,.8,.4, 0> ]
				[ 0.280  0.470 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
				[ 0.470  0.480 color rgbf <.4,.4,.5, 0> color rgbf <.4,.4,.8, 0> ]
				[ 0.480  0.680 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
				[ 0.680  0.690 color rgbf <.5,.4,.4, 0> color rgbf <.8,.4,.4, 0> ]
				[ 0.690  0.880 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
				[ 0.880  0.890 color rgbf <.5,.5,.5, 0> color rgbf < 1, 1, 1, 0> ]
				[ 0.890  1.000 color rgbf < 0, 0, 0, 1> color rgbf < 0, 0, 0, 1> ]
			}
			turbulence 1
			sine_wave
			scale .5
		}
	}
#else
	//day sky

	sky_sphere {
		pigment {
			color rgb <0.25, 0.25, 0.5>
		}
	}
#end

//mountain peaks

#if (use_mountains = yes)
	#if (final_output= yes)
		#declare aPeak = object { mountain_peak(5, .75, 99)
			rotate <0, 45, 0>
			no_shadow
		}
		#declare rightPeak = object { mountain_peak(6, .8,253898)
			rotate <0, 45, 0>
			scale <1.4, 1, 1>
			no_shadow
		}
		#declare leftPeak = object { mountain_peak(6, .8, 12338)
			rotate <0, 45, 0>
			scale <1.1, 1, 1>
			no_shadow
		}

	#else
		#declare aPeak = cone {
			<0,0,0>, 1
			<0, 1, 0>, 0
			no_shadow
		}
		#declare rightPeak = object { aPeak }
		#declare leftPeak = object { aPeak}
	#end
	//far left
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1.25
		scale <1, .8, 1>
		rotate <0, 32, 0>
		translate <0, earthRadius, 0>
		rotate <14, 0, 8.4>
		translate <0, -earthRadius, 0>
	}

	//medium left
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1.2
		rotate <0, 64, 0>
		scale <1.5, .8, 1>
		translate <0, earthRadius, 0>
		rotate <15, 0, 6>
		translate <0, -earthRadius, 0>
	}

	//left middle left
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1
		rotate <0, 64, 0>
		scale <2, .8, 1>
		translate <0, earthRadius, 0>
		rotate <14.5, 0, 4.5>
		translate <0, -earthRadius, 0>
	}

	//middle left
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1.15
		scale <1, .8, 1>
		rotate <0, 96, 0>
		translate <0, earthRadius, 0>
		rotate <15, 0, 3>
		translate <0, -earthRadius, 0>
	}

	//right middle left
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1
		rotate <0, 55, 0>
		scale <1.8, .8, 1>
		translate <0, earthRadius, 0>
		rotate <15, 0, 1.5>
		translate <0, -earthRadius, 0>
	}

	//middle
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1.2
		scale <1, .8, 1>
		rotate <0, 128, 0>
		translate <0, earthRadius, 0>
		rotate <15, 0, 0>
		translate <0, -earthRadius, 0>
	}

	//middle right
	object { leftPeak
		texture {mountainTexture}
		scale moonRadius*1
		rotate <0, 160, 0>
		translate <0, earthRadius, 0>
		rotate <14, 0, -2>
		translate <0, -earthRadius, 0>
	}

	//right
	#if (use_mist = yes)
	union {
		sphere {
			<0,0,0>, 1
			pigment {
				color rgbf <1,1,1,1>
			}
			interior {
				media {
					//mie haze scattering
					scattering {
						1, rgb .3
						extinction .2
					}
					samples 3, 3
					method 3
					aa_level 1
					aa_threshold .1
					//1 is dense fog
					//0 is no fog
					
					//first a sphere to make it peter out towards the edges
					density {
						spherical
						turbulence .5
						//remember, 1 is origin, 0 is surface, for spherical
						color_map {
							[0	color 0.0]
							[.6 color 0.0]
							[.7 color .012]
							[1	color .012]
						}
					}
				}
			}
			hollow
			scale <.85, .09, .85>
			translate <0, .75, 0>
		}
	#end
	object { rightPeak
		texture {mountainTexture}
	#if (use_mist = yes)
		}
	#end
		scale moonRadius*1.5
		rotate <0, 192, 0>
		translate <0, earthRadius, 0>
		rotate <16, 0, -5>
		translate <0, -earthRadius, 0>
	}

	//far right behind
	#if (use_mist = yes)
	union {
		sphere {
			<0,0,0>, 1
			pigment {
				color rgbf <1,1,1,1>
			}
			interior {
				media {
					//mie haze scattering
					scattering {
						1, rgb .3
						extinction .2
					}
					samples 3, 3
					method 3
					aa_level 1
					aa_threshold .1
					//1 is dense fog
					//0 is no fog
					
					//first a sphere to make it peter out towards the edges
					density {
						spherical
						turbulence .3
						//remember, 1 is origin, 0 is surface, for spherical
						color_map {
							[0	color 0.0]
							[.4 color 0.0]
							[.5 color .012]
							[1	color .012]
						}
					}
				}
			}
			hollow
			scale <.8, .09, .6>
			translate <0, .82, 0>
		}
	#end
	object { aPeak
		texture {mountainTexture}
	#if (use_mist = yes)
		}
	#end
		scale moonRadius*1.6
		rotate <0, 224, 0>
		translate <0, earthRadius, 0>
		rotate <16, 0, -7>
		translate <0, -earthRadius, 0>
	}

	//far right
	object { aPeak
		texture {mountainTexture}
		scale moonRadius*1.5
		rotate <0, 256, 0>
		translate <0, earthRadius, 0>
		rotate <16, 0, -11>
		translate <0, -earthRadius, 0>
	}
#end

#if (use_fog = yes)
	#if (final_output = yes)
		#declare fogHeight = 3;
		#declare fogRadius = earthRadius+fogHeight;
		#declare fogHalf = earthRadius + fogHeight/3;
		#declare fogStart = 1-earthRadius/fogRadius;
		#declare fogHalf = 1-earthRadius/fogHalf;
		sphere {
			<0,0,0>, 1
				pigment {
				color rgbf <1,1,1,1>
			}
			interior {
				media {
					//mie haze scattering
					scattering {
						2, rgb .3
						extinction 2
					}
					samples 3, 3
					method 3
					aa_level 1
					aa_threshold .1
					//1 is dense fog
					//0 is no fog
					
					//first a sphere to make it peter out towards the top
					density {
						spherical
						//remember, 1 is origin, 0 is surface, for spherical
						color_map {
							[0	color 0.0]
							[fogHalf color 0.0]
							[fogStart color 1.0]
							//[200*fogStart color 0.0]
							[1	color 1.0]
						}
					}
					
					//now, the real fog--bozo
					density {
						bozo
						//turbulence .5
						//remember, 1 is origin, 0 is surface, for spherical
						color_map {
							[0	color 0.0]
							[.5 color 0.0]
							[1	color 1.0]
						}
						scale 2/fogRadius
					}
					
					//finally, let's make the fog only be over here, not further back
					density {
						gradient z
						color_map {
							[0 color 1.0]
							[10/fogRadius color 1.0]
							[50/fogRadius color 0.0]
							[1 color 0.0]
						}
					}
				}
			}
		
			hollow on
		
			scale <fogRadius, fogRadius, fogRadius>
			translate <0, -earthRadius, 0>
		}
	#else
		//ground fog
		fog {
			distance .6
			color .2
			fog_type 2
			fog_offset 1
			fog_alt .1
			turbulence .5
		}
	#end
#end

#if (use_grail = 1)
	#declare well_height = 2;
	#declare well_radius = 2;
	#declare well_inner_radius = well_radius - .5;
	#declare water_height = well_height - .25;
	union {
		//the well
		difference {
			cylinder {
				<0, -1, 0>, <0, well_height, 0>, well_radius
			}
			cylinder {
				<0, 0, 0>, <0, well_height*1.01, 0>, well_inner_radius
			}
			texture {
				T_Stone44
				scale 6
			}
		}
		//the water
		cylinder {
			<0, 0, 0>, <0, water_height, 0>, well_inner_radius
			texture {
				pigment {
					color rgbf <.8, 1, .8, 1>
				}
				finish {
					reflection {
						.6
					}
					diffuse .6
					specular .3
					roughness .7
				}
			}
		}
		//the grail
		lathe {
			cubic_spline
			14,
				<-60,-68>,
				<0,-68>,
				<60,-68>,
				<63,-66>,
				<30,-56>,
				<12,-33>,
				<9,-7>,
				<6,-4>,
				<6,2>,
				<12,2>,
				<44,20>,
				<57,61>,
				<55,63>,
				<-60,63>
			translate <0, 68, 0>
			scale v_scale
			#if (final_output = 1)
				texture {
					EmbossedGold
					scale .5
				}
			#else
				pigment {
					Gold
				}
			#end
			scale .75
			translate <(well_inner_radius+well_radius)/2, well_height, 0>
			rotate <0, 33, 0>
		}
		translate <0, earthRadius, 0>
		rotate <.04, 0, 0>
		translate <0, -earthRadius, 0>
		//translate <0, 0, 7>
	}
#end

#if (use_grass = yes)
	//grass around the well
	#include "grasspatch.inc"
	#declare Patch_Shape = 0;
	#declare Clump_Radius_Minimum = 1.6;
	#declare Clump_Radius_Maximum = 2.2;
	#declare Blade_Scale = .25;
	#declare Blade_Density = 5;
	#declare Spread_Correction = 0.3;
	union {
		PlantPatch()
		//translate <0, -.4, 0>
		translate <0, earthRadius, 0>
		rotate <.04, 0, 0>
		translate <0, -earthRadius, 0>
	}
	
	//general grass
	#include "grass.inc"
	object{
		MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
		texture {
			txtGrass
			scale 40
		}
		//scale <2, 1, 2>
	}  

#end



camera {
	location <0, 5, -5>
	look_at <0, 4, 0>

/*	//look at well
	location <0, 5, 2>
	look_at <0, 2, 7>
*/

	right x*image_width/image_height
}

